using namespace std;

#ifndef CTerrainSplited_h
#define CTerrainSplited_h

#include <pthread/pthread.h>
#include "Vecteur.h"

class CTerrainSplited
{
    friend void *fMkTerrain(void *data);//thread de construction de terrain alatoire
    friend void *fMkNorm(void *data);//thread de calcul des normales
    
    private:
        Vecteur p;
        unsigned int w,h;//peace of area
        
        float sclX,sclY,sclZ;//echelle
        float spdX,spdY;//taux de rptition des textures
        
        float limitW;//limitW=w*sclX;
        float limitH;//limitH=h*sclZ;
        
        unsigned int idTex;
        
        bool okThrd;//si le thread peut continuer
        bool bFabrique,bFabriqueOld;
        pthread_t fabrique,fabriqueOld;
        pthread_mutex_t mtxTabTr;
        
        //Usine de terrain
        char **oldMNT;
        struct STr{char **tr;};
        unsigned char nbMkTr,Fourn,Thrd;
        STr *mkTr;
        float **r,**f;
        //-----------------
        
        //Usine de normal
        char **mntClNrm;
        bool bCalculNrm;
        pthread_t calculNrm;
        pthread_mutex_t mtxNrm;
        Vecteur **norml;
        //---------------
        
        //Liste de terrain  afficher
        struct STrGID{STr tr;unsigned int gID;};
        unsigned char nbTer,terSel;
        STrGID *Ters;
        float posix;
        //---------------------------
        
        //Retourne l'indice du terrain contruit en liste de commandes OpenGL
        // partir d'un terrain sortant des usines
        unsigned int mkGraphicArea(char **mnt);
        STrGID getTerrain();//cette fonction se charge faire la demande d'un terrain dispo des usines
        
        //Fonction d'injection d'un nouveau terrain en bou et donc de la suppression de l'ancien terrain
        void putOtherArea();
        
        float getIDAreaPoint(float z);//retourne l'indice du terrain  la position z (on peut arrondire  l'entier prs )
        float getHeightMNT(float x,float z,char **mnt);//hauteur du terrain en ces points pour ce morceau mnt
        float tryInterserct(char **mnt,Vecteur vA,Vecteur dir,float hypo,float maxT,float precis);//ne fonctione pas trs bien
        
    public:
        CTerrainSplited();
        ~CTerrainSplited();
        
        //Paramtrage du terrain
        void InitTerrain(Vecteur p,unsigned int w,unsigned int h,float sclX,float sclY,float sclZ,float spdX,float spdY,unsigned char nbMkTr,unsigned char nbTer);
        void clear();
        
        void frameMove(float px);
        void render();
        
        float getHeight(float x,float z);//hauteur du terrain en ces points
        void getNormal(Vecteur &v,float x,float z);//obtenir la pante
        float getIntersec(Vecteur v,Vecteur d,float maxTime,float r=1.0,float precis=1.0);//ne fonctione pas trs bien
        
        void setTexture(unsigned int idTex);//mettre la texture 3D du terrain
        
        float getLimitTest(float x,float z);//ne sert pas
};

char **clearMnt(unsigned int h,char **mnt);//fonction de destruction d'une matrice de terrain

void *fMkTerrain(void *data);//usine terrain
void *fMkNorm(void *data);//usine normals

#endif
